<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User;

use Erlage\Photogram\Data\Dtos\Common\UserIdsDTO;
use Erlage\Photogram\Data\Dtos\User\UserDisplayImageDTO;
use Erlage\Photogram\Data\Dtos\User\UserMetaPushSettingsDTO;

interface InterfaceUserSetter
{
    /**
     * @return static 
     */
    public function setId(string $id);

    /**
     * @return static 
     */
    public function setEmail(string $email);

    /**
     * @return static 
     */
    public function setUsername(string $username);

    /**
     * @return static 
     */
    public function setPassword(string $password);

    /**
     * @return static 
     */
    public function setDisplayName(string $displayName);

    /**
     * @return static 
     */
    public function setDisplayBio(string $displayBio);

    /**
     * @return static 
     */
    public function setDisplayImage(UserDisplayImageDTO $displayImage);

    /**
     * @return static 
     */
    public function setDisplayWeb(string $displayWeb);

    /**
     * @return static 
     */
    public function setMetaAccess(string $metaAccess);

    /**
     * @return static 
     */
    public function setMetaIsPrivate(string $metaIsPrivate);

    /**
     * @return static 
     */
    public function setMetaIsEmailVerified(string $metaIsEmailVerified);

    /**
     * @return static 
     */
    public function setMetaLastActive(string $metaLastActive);

    /**
     * @return static 
     */
    public function setMetaPushSettings(UserMetaPushSettingsDTO $metaPushSettings);

    /**
     * @return static 
     */
    public function setCachePostsCount(string $cachePostsCount);

    /**
     * @return static 
     */
    public function setCacheFollowersCount(string $cacheFollowersCount);

    /**
     * @return static 
     */
    public function setCacheFollowingsCount(string $cacheFollowingsCount);

    /**
     * @return static 
     */
    public function setCacheBlockedUserIds(UserIdsDTO $cacheBlockedUserIds);

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration);

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate);
}
